<?php if ( function_exists( 'acf_add_local_field_group' ) ) :

    acf_add_local_field_group( [
        "key" => "group_593be7a6c2017prd",
        "title" => __( 'Single Product Settings', 'ohio' ),
        "private" => true,
        "fields" => [
            [
                "key" => "field_583be7a6d2429",
                "label" => __( 'General', 'ohio' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_47272c6ed00aeasf",
                "label" => __( 'Layout', 'ohio' ),
                "name" => "global_ecommerce_product_type",
                "type" => "image_option",
                "instructions" => __( 'Choose a single product layout for the entire site.', 'ohio' ),
                "conditional_logic" => 0,
                "default_value" => "type1",
                "image_option_value" => [
                    [
                        "name" => "type1",
                        "description" => __( 'Sticky Gallery', 'ohio' ),
                        "src" => "acf__image_27.svg"
                    ],
                    [
                        "name" => "type2",
                        "description" => __( 'Sticky Gallery - Reflected', 'ohio' ),
                        "src" => "acf__image_26.svg"
                    ],
                    [
                        "name" => "type3",
                        "description" => __( 'Split Screen', 'ohio' ),
                        "src" => "acf__image_29.svg"
                    ],
                    [
                        "name" => "type4",
                        "description" => __( 'Split Screen - Reflected', 'ohio' ),
                        "src" => "acf__image_28.svg"
                    ],
                    [
                        "name" => "type5",
                        "description" => __( 'Classic Gallery', 'ohio' ),
                        "src" => "acf__image_49.svg"
                    ],
                    [
                        "name" => "type6",
                        "description" => __( 'Classic Gallery - Reflected', 'ohio' ),
                        "src" => "acf__image_50.svg"
                    ],
                    [
                        "name" => "type7",
                        "description" => __( 'Grid Gallery', 'ohio' ),
                        "src" => "acf__image_47.svg"
                    ],
                    [
                        "name" => "type8",
                        "description" => __( 'Grid Gallery - Reflected', 'ohio' ),
                        "src" => "acf__image_48.svg"
                    ]
                ]
            ],
            [
                "key" => "field_593be7a6d18qlgt",
                "label" => __( 'Lightbox', 'ohio' ),
                "name" => "global_woocommerce_product_lightbox_preview",
                "type" => "true_false",
                "instructions" => __( 'Enable a lightbox preview for product gallery images.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d18qlgt",
                "label" => __( 'Sticky Product', 'ohio' ),
                "name" => "global_woocommerce_product_sticky",
                "type" => "true_false",
                "instructions" => __( 'Enable a sticky product bar for product pages.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593benajslodkihoih",
                "label" => __( 'Zoom Effect', 'ohio' ),
                "name" => "global_woocommerce_product_zoom",
                "type" => "true_false",
                "instructions" => __( 'Enable a hover zoom effect for product gallery images.', 'ohio' ),
                "required" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d18932354",
                "label" => __( 'AJAX Add to Cart', 'ohio' ),
                "name" => "global_woocommerce_product_ajax_cart",
                "type" => "true_false",
                "instructions" => __( 'Enable an AJAX add-to-cart feature without page reloading.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d1893s",
                "label" => '<h4>' . __( 'Styles and Display', 'ohio' ) . '</h4>',
                "name" => "",
                "type" => "message"
            ],
            [
                "key" => "field_592fd62342342a3124",
                "label" => __( 'Next/Prev Navigation', 'ohio' ),
                "name" => "global_woocommerce_product_navigation",
                "type" => "true_false",
                "instructions" => __( 'Show a sticky navigation bar with the next/previous product links.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_593be8a6d18930",
                "label" => __( 'Sale Badge', 'ohio' ),
                "name" => "global_woocommerce_product_sale_badge",
                "type" => "true_false",
                "instructions" => __( 'Show a sale badge on a single product.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d18932",
                "label" => __( 'Stock Badge', 'ohio' ),
                "name" => "global_woocommerce_product_stock_badge",
                "type" => "true_false",
                "instructions" => __( 'Show a stock badge on a single product.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d1893b",
                "label" => __( 'SKU', 'ohio' ),
                "name" => "global_woocommerce_product_sku",
                "type" => "true_false",
                "instructions" => __( 'Show a SKU (stock keeping unit) on a single product.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d1893c",
                "label" => __( 'Categories', 'ohio' ),
                "name" => "global_woocommerce_product_category",
                "type" => "true_false",
                "instructions" => __( 'Show a categories list on a single product.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593be8a6d1893d",
                "label" => __( 'Tags', 'ohio' ),
                "name" => "global_woocommerce_product_tags",
                "type" => "true_false",
                "instructions" => __( 'Show a tags list on a single product.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
            [
                "key" => "field_593f4haf12422c",
                "label" => __( 'Title Typography', 'ohio' ),
                "name" => "global_page_woocommerce_single_product_title_typo",
                "type" => "ohio_typo",
                "instructions" => __( 'Set the typography and color for the product title.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => false
            ],
            [
                "key" => "field_592f4aff12422a",
                "label" => __( 'Price Typography', 'ohio' ),
                "name" => "global_page_woocommerce_single_product_price_typo",
                "type" => "ohio_typo",
                "instructions" => __( 'Set the typography and color for the product price.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => false
            ],
            [
                "key" => "field_593f4hff12422b",
                "label" => __( 'Meta Typography', 'ohio' ),
                "name" => "global_page_woocommerce_single_product_meta_typo",
                "type" => "ohio_typo",
                "instructions" => __( 'Set the typography and color for the product meta.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "add_theme_inherited" => false
            ],

            [
                "key" => "field_583be7a6d2429tpg",
                "label" => __( 'Related Products', 'ohio' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59fb4ad44a336199",
                "label" => __( 'Related Products', 'ohio' ),
                "name" => "global_woocommerce_product_related",
                "type" => "true_false",
                "instructions" => __( 'Show a related products section below the single product area.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "message" => "",
                "default_value" => 1,
                "ui" => 1,
                "ui_on_text" => "",
                "ui_off_text" => ""
            ],
            [
                "key" => "field_59fb4ad44a1dtd336199",
                "label" => __( 'Number of Products', 'ohio' ),
                "name" => "global_woocommerce_product_related_amount",
                "type" => "text",
                "instructions" => __( 'Set a number of related products per section.', 'ohio' ),
                "required" => 0,
                "default_value" => "3",
                "new_lines" => "",
                "esc_html" => 0,
                "append" => __( 'products', 'ohio' ),
				"conditional_logic" => [
                    [
                        [
                            "field" => "field_59fb4ad44a336199",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ]
            ],
            [
                "key" => "field_592305972309",
                "label" => __( 'Sharing', 'ohio' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_593743w37383615",
                "label" => __( 'Sharing', 'ohio' ),
                "name" => "global_woocommerce_sharing_visibility",
                "type" => "true_false",
                "instructions" => __( 'Enable sharing feature for single products.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "new_lines" => "",
                "esc_html" => 0,
                "ui" => true
            ],
            [
                "key" => "field_593743e37383615",
                "label" => __( 'Sharing Networks', 'ohio' ),
                "name" => "global_woocommerce_sharing_networks",
                "type" => "select",
                "instructions" => __( 'Choose social networks to be available for sharing through.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593743w37383615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ],
                "choices" => [
                    "facebook" => __( 'Facebook', 'ohio' ),
                    "twitter" => __( 'X', 'ohio' ),
                    "pinterest" => __( 'Pinterest', 'ohio' ),
                    "linkedin" => __( 'LinkedIn', 'ohio' )
                ],
                "default_value" => [],
                "allow_null" => 0,
                "multiple" => 1,
                "ui" => 1,
                "ajax" => 1,
                "return_format" => "value",
                "placeholder" => ""
            ],
            [
                "key" => "field_593743w37383616",
                "label" => __( 'Open in New Tab', 'ohio' ),
                "name" => "global_woocommerce_sharing_networks_target_blank",
                "type" => "true_false",
                "instructions" => __( 'Open a sharing dialog window in a new browser tab.', 'ohio' ),
                "default_value" => 1,
                "ui" => 1,
                "conditional_logic" => [
                    [
                        [
                            "field" => "field_593743w37383615",
                            "operator" => "==",
                            "value" => "1"
                        ]
                    ]
                ]
            ],
            [
                "key" => "field_593beba6d4b64",
                "label" => __( 'Other', 'ohio' ),
                "name" => "",
                "type" => "tab",
                "instructions" => "",
                "required" => 0,
                "conditional_logic" => 0,
                "placement" => "top",
                "endpoint" => 0
            ],
            [
                "key" => "field_59223095872",
                "label" => '<h4>' . __( 'Breadcrumbs', 'ohio' ) . '</h4>',
                "name" => "",
                "type" => "message"
            ],
            [
                "key" => "field_593be7a6fas124d437b",
                "label" => __( 'Category Slug', 'ohio' ),
                "name" => "global_woocommerce_page_show_category_breadcrumbs",
                "type" => "true_false",
                "instructions" => __( 'Show a category slug in the breadcrumbs structure.', 'ohio' ),
                "required" => 0,
                "conditional_logic" => 0,
                "allow_null" => 0,
                "other_choice" => 0,
                "save_other_choice" => 0,
                "default_value" => "1",
                "layout" => "horizontal",
                "return_format" => "value",
                "ui" => 1,
                "ui_on_text" => __( 'Yes', 'ohio' ),
                "ui_off_text" => __( 'No', 'ohio' )
            ],
        ],
        "location" => [
            [
                [
                    "param" => "options_page",
                    "operator" => "==",
                    "value" => "theme-general-product"
                ]
            ]
        ],
        "menu_order" => 0,
        "position" => "normal",
        "style" => "default",
        "label_placement" => "left",
        "instruction_placement" => "label",
        "hide_on_screen" => "",
        "active" => 1,
        "description" => ""
    ] );

endif;
